import {
  ViewerApp,
  AssetManagerPlugin,
  addBasePlugins,
  MaterialConfiguratorPlugin
} from "https://dist.pixotronics.com/webgi/runtime/bundle-0.9.3.mjs";

async function setupViewer() {
  // Initialize the viewer
  const viewer = new ViewerApp({
    canvas: document.getElementById("mcanvas")
  });

  // Add all the plugins at once
  await addBasePlugins(viewer);

  await viewer.addPlugin(MaterialConfiguratorPlugin)
  // This must be called after adding any plugin that changes the render pipeline.
  viewer.renderer.refreshPipeline();

  // Load a 3d model configured in the webgi editor using MaterialConfiguratorPlugin
  await viewer.load(
    "https://demo-assets.pixotronics.com/pixo/gltf/material_configurator.glb"
  );

}

setupViewer();